<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSkinEditor extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "skineditor") {
			switch ($_GET["sub"]) {
				case "change":
					return $this->ChangeSkin();
				break;

				case "cookies.accept":
					return $this->CookiesAccept();
				break;
			}
		}


		if ($_GET["submod"] == "currency") {
			return $this->CronTab();
		}

		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetSkin($mod_id , $system = false) {
		global $_CONF , $base;

		if ($base->isTablet) {
			//tablet
			$cond .= " AND find_in_set(2,skin_device) ";
		} elseif ($base->isMobile) {
			//phone
			$cond .= " AND find_in_set(3,skin_device) ";
		} else {
			//desktop
			$cond .= " AND find_in_set(1,skin_device) ";
		}

		if ($system) {
			$skin = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE find_in_set({$mod_id} , skin_modules_global) {$cond} ORDER BY rand() limit 1"
			);
		} else {

			$skin = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE find_in_set({$mod_id} , skin_modules) {$cond} ORDER BY rand() limit 1"
			);
		}


		if (!is_array($skin)) {
			$skin = $this->GetDefaultSkin();
		} else {
			$skin = array(
				"skin_id"		=> $skin["skin_id"],
				"skin_parent"	=> $skin["skin_parent"]
			);
		}

		
		return $skin;
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetDefaultSkin() {
		global $base;

		if ($base->isTablet) {
			//tablet
			$skin = $this->vars->data["set_skin_tablet"];
		} elseif ($base->isMobile) {
			//phone
			$skin = $this->vars->data["set_skin_phone"];
		} else {
			//desktop
			$skin = $this->vars->data["set_skin"];
		}

		$skin_data = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE skin_id=%d " , array($skin)
		);
		
		return $skin = array(
			"skin_id"	=> $skin_data["skin_id"],
			"skin_parent"	=> $skin_data["skin_parent"],
		);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_SESS , $_LANG_ID , $_TSM, $_LANG , $_LANG_RAW;


		//skin forced from admin
		if ($_SESS["skineditor"]) {

			$skin_data = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['core:skins']} WHERE skin_id={$_SESS[skineditor]}"
			);

			$skin = array(
				"skin_id"	=> "preview",
				"skin_parent" => $skin["skin_parent"]
			);
		} else {

			if ($_SESS["locale"]["skin"]) {
				$skin = array(
					"skin_id"	=> $_SESS["locale"]["skin"]
				);

			} elseif ($this->vars->data["set_skin_type"] == "1") {
				$skin = 	$this->plugins["skineditor"]->GetDefaultSkin();
			} else {


				if ($module["mod_id"]) {
					$skin = 	$this->plugins["skineditor"]->GetSkin($module["mod_id"]);
				} elseif ($module["module_id"]) {
					$skin = 	$this->plugins["skineditor"]->GetSkin($module["module_id"] , true);
				} else {
					//load default skin
					$skin = $this->plugins["skineditor"]->GetDefaultSkin();
				}
			}
		}

		$types = array(
			"0"	=> "prod",
			"1"	=> "dev",
			"2"	=> "dev",
		);

		$js = array("type" => $types[$this->vars->data["set_page_js"]]);

		if ($this->vars->data["set_page_js"] == "2") {
			$js["stamp"] = time();
		} elseif ($this->vars->data["set_page_js_ver"]) {
			$js["ver"] = $this->vars->data["set_page_js_ver"];
		} 

		$_TSM["OPT_JS_NOCACHE"] = "?" . http_build_query($js);


		$css = array("type" => $types[$this->vars->data["set_page_css"]]);

		if ($this->vars->data["set_page_css"] == "2") {
			$css["stamp"] = time();
		} elseif ($this->vars->data["set_page_css_ver"]) {
			$css["ver"] = $this->vars->data["set_page_css_ver"];
		} 

		$_TSM["OPT_CSS_NOCACHE"] = "?" . http_build_query($css);


		if ($_GET["mod"] == "maintenance") {
			$rtl_css = "assets/maintenance/css/intl/{$_LANG_RAW[lang_dir]}.css";
			$rtl_php = "assets/maintenance/css/intl/{$_LANG_RAW[lang_dir]}.php";
		} else {
			$rtl_css = "assets/css/intl/{$_LANG_RAW[lang_dir]}.css";
			$rtl_php = "assets/css/intl/{$_LANG_RAW[lang_dir]}.php";
		}
		
		if (file_exists($rtl_css)) {
			$this->plugins["seo"]->AddStylesheet("{PRIV.BASE.HREF}{$rtl_css}{OPT_CSS_NOCACHE}");		
		} elseif (file_exists($rtl_php)) {
			$this->plugins["seo"]->AddStylesheet("{PRIV.BASE.HREF}{$rtl_php}{OPT_CSS_NOCACHE}");		
		}

		if ($lang_skin = $this->db->QFetchRowArray("SELECT skin_id,skin_head FROM {$this->tables['core:skins_fonts']} WHERE skin_lang LIKE '{$_LANG}'")) {

			if (is_array($lang_skin)) {
				foreach ($lang_skin as $key => $val) {
					$this->plugins["seo"]->AddStylesheet("{PRIV.BASE.HREF}upload/skins/lang_{$val[skin_id]}.css{OPT_CSS_NOCACHE}");		

					if ($val["skin_head"]) {
						$this->plugins["seo"]->AppendToHead($val["skin_head"]);
					}
				}				
			}
		}

		if (is_array($skin)) {

			if ($skin["skin_parent"]) {

				if ($skin["skin_parent"] == "-1") {

					if ($_GET["mod"] != "maintenance") {					
						$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}assets/css/skin.php{OPT_CSS_NOCACHE}');		
					}
				} else {
					$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}upload/skins/' . $skin['skin_parent'] .'.css{OPT_CSS_NOCACHE}');		
				}
				
			}

			//default skin
			if ($skin["skin_id"] == "-1") {
				if ($_GET["mod"] != "maintenance") {
					if ($_GET["mod"] != "maintenance") {					
						$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}assets/css/skin.php{OPT_CSS_NOCACHE}');
					}
				}
			} else {
				$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}upload/skins/' . $skin['skin_id'] .'.css{OPT_CSS_NOCACHE}');					
			}
		} else {
			//load the default skin file
			if ($_GET["mod"] != "maintenance") {					
				$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}assets/css/skin.php{OPT_CSS_NOCACHE}');		
			}
		}

		if (file_exists('upload/skins/overlays.css')) {
			$this->plugins["seo"]->AddStylesheet('{PRIV.BASE.HREF}upload/skins/overlays.css{OPT_CSS_NOCACHE}');		
		} 

		$this->VisualSettings();		
		//$this->bodyAttrs();

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function VisualSettings() {

		global $_TSM , $_LANG_RAW, $base;


		$this->setBodyAttr("data-menu-over-title" , $this->vars->data["set_menu_page"] ? "true" : "false");
				
		if ($this->vars->data["set_menu_position"] == "t") {
			$this->setBodyClass($this->vars->data["set_style_boxed"]);
		}

		$_TSM["PUB:COPYRIGHT"] = "";

		if ($_GET["module_id"]) {
			$this->setBodyClass("page-" . $_GET["module_id"])->setBodyClass("page-" . ($this->plugins["globalhooks"]->module_data["mod_url"] ? $this->plugins["globalhooks"]->module_data["mod_url"] : $this->plugins["globalhooks"]->module_data["module_url"]));
		}
	


		$preloader = new CTemplateDynamic($this->tpl_path . "preloader.htm");
		$backtotop = new CTemplateDynamic($this->tpl_path . "backtotop.htm");
		$backtotop = $backtotop->blockReplace(
			"Main" , 
			array(
				"set_back_top_in"	=> $this->vars->data["set_back_top_in"] ? "animated " . $this->vars->data["set_back_top_in"] : "",
				"set_back_top_out"	=> $this->vars->data["set_back_top_out"] ? "animated " . $this->vars->data["set_back_top_out"] : "",
				"set_back_top_time"	=> $this->vars->data["set_back_top_time"],
				"set_back_top_anim"	=> $this->vars->data["set_back_top_anim"],
			)
		);

		$this->vars->data["set_preloader"] = explode("," , $this->vars->data["set_preloader"]);
		$this->vars->data["set_back_top"] = explode("," , $this->vars->data["set_back_top"]);
		$this->vars->data["set_cookies_show"] = explode("," , $this->vars->data["set_cookies_show"]);
		$this->vars->data["set_footer_collapsed"] = explode("," , $this->vars->data["set_footer_collapsed"]);
		$this->vars->data["set_menu_sticky"] = explode("," , $this->vars->data["set_menu_sticky"]);
		
		if ($base->isTablet) {
			$this->setBodyClass("device-is-tablet");

			if (in_array(2,$this->vars->data["set_preloader"])) {
				$this->plugins["seo"]->PrependToBody(
					$preloader->blockReplace(
						"Main",
						$this->plugins["backgrounds"]->getBg($this->vars->data["set_preloader_bg"]),
						array(	
							"BG:SCHEME"	=> "nc"
						)
					));
			}

			if (in_array(2,$this->vars->data["set_back_top"])) {
				$this->plugins["seo"]->PrependToBody($backtotop);
			}

			if (in_array(2,$this->vars->data["set_footer_collapsed"])) {
				$this->setBodyAttr("data-footer-collapse" , "true");
			}

			if (in_array(2,$this->vars->data["set_cookies_show"])) {
				$this->CookieNotification();
			}

			if (in_array(2,$this->vars->data["set_menu_sticky"])) {
				$this->setBodyAttr("data-menu-sticky" , "true");
			}

		} elseif ($base->isMobile) {

			$this->setBodyClass("device-is-mobile");

			if (in_array(3,$this->vars->data["set_preloader"])) {
				$this->plugins["seo"]->PrependToBody(
					$preloader->blockReplace(
						"Main",
						$this->plugins["backgrounds"]->getBg($this->vars->data["set_preloader_bg"]),
						array(	
							"BG:SCHEME"	=> "nc"
						)
					));
			}

			if (in_array(3,$this->vars->data["set_back_top"])) {
				$this->plugins["seo"]->PrependToBody($backtotop);
			}

			if (in_array(3,$this->vars->data["set_cookies_show"])) {
				$this->CookieNotification();
			}


			if (in_array(3,$this->vars->data["set_footer_collapsed"])) {
				$this->setBodyAttr("data-footer-collapse" , "true");
			}

			if (in_array(3,$this->vars->data["set_menu_sticky"])) {
				$this->setBodyAttr("data-menu-sticky" , "true");
			}

		} else {
		
			if (in_array(1,$this->vars->data["set_preloader"])) {
				$this->plugins["seo"]->PrependToBody(
					$preloader->blockReplace(
						"Main",
						$this->plugins["backgrounds"]->getBg($this->vars->data["set_preloader_bg"]),
						array(	
							"BG:SCHEME"	=> "nc"
						)
					));
			}

			if (in_array(1,$this->vars->data["set_back_top"])) {
				$this->plugins["seo"]->PrependToBody($backtotop);
			}

			if (in_array(1,$this->vars->data["set_cookies_show"])) {
				$this->CookieNotification();
			}

			if (in_array(1,$this->vars->data["set_footer_collapsed"])) {
				$this->setBodyAttr("data-footer-collapse" , "true");
			}

			if (in_array(1,$this->vars->data["set_menu_sticky"])) {
				$this->setBodyAttr("data-menu-sticky" , "true");
			}
		}

		$_TSM["PUB:SET_MENU_STYLE"] = $_TSM["PUB:MENU_STYLE_WIDTH"] = "";

		$logo = array(
			"0"	=> "logo-outside",
			"1"	=> "logo-inside-main",
			"2"	=> "logo-inside-sec"
		);

		$_TSM["PUB:MENU_STYLE_WIDTH"] = "container";

		switch ($this->vars->data["set_menu_position"]) {
			//top menu
			default:
			case "t":

				$menu = array(
					"l"		=> "main-navbar-left",
					"r"		=> "main-navbar-right",
					"c"		=> "main-navbar-top",
					"lr"	=> "main-navbar-split",
					"lc"	=> "main-navbar-split main-navbar-split-centered"
				);
				
				$_TSM["PUB:MENU_STYLE_WIDTH"] = $this->vars->data["set_menu_width"] ? "container-fluid" : "container";

				$this->setBodyClass("menu-open")
					->setBodyClass($menu[$this->vars->data["set_menu_style"]])
					->setBodyClass("menu-" . $logo[(int)$this->vars->data["set_menu_collapse_logo"]])
					->setBodyAttr("data-menu-collapse" , $this->vars->data["set_menu_collapse_width"])
					->setBodyAttr("data-menu-sticky-logo" , $this->vars->data["set_menu_sticky_logo"] ? "true" : "false");

				if ($this->vars->data["set_menu_collapse_logo"]) {
					$this->setBodyClass("menu-logo-inside");
				}
				
			break;

			//side menu
			case "s":

				$this->setBodyClass("menu-close");

				if ($this->vars->data["set_menu_sec"] == "2") {
					$this->setBodyClass("menu-side-sec");
				}

				if ($this->vars->data["set_menu_main"] == "2") {
					$this->setBodyClass("menu-side-main");
				}

				//if both are collapsed then its the same as its allwayc collapsed
				if (($this->vars->data["set_menu_sec"] != "2" ) && ($this->vars->data["set_menu_main"] != "2")) {
					$this->setBodyAttr("data-menu-collapse" , "100000")
						->setBodyClass("menu-working")
//						->setBodyClass("menu-close-allways")
						//overwrite the option of the logo possition with the one from collapsed
						->setBodyClass("menu-" . $logo[(int)$this->vars->data["set_menu_collapse_logo"]]);

					if ($this->vars->data["set_menu_collapse_logo"]) {
						$this->setBodyClass("menu-logo-inside");
					}


				} else {
					//else use the logo position from collapse
					$this->setBodyClass("menu-side-" . $logo[(int)$this->vars->data["set_menu_side_logo"]])
						->setBodyClass("menu-" . $logo[(int)$this->vars->data["set_menu_collapse_logo"]])
						->setBodyClass("menu-side")
						->setBodyAttr("data-menu-collapse" , $this->vars->data["set_menu_collapse_width"]);

						if ($this->vars->data["set_menu_side_logo"]) {
							$this->setBodyClass("menu-side-logo-inside");
						}

					if ($this->vars->data["set_menu_collapse_logo"]) {
						$this->setBodyClass("menu-logo-inside");
					}

				}
			break;

			//allways collapsed
			case "sc":
				$this->setBodyClass("menu-" . $logo[(int)$this->vars->data["set_menu_collapse_logo"]])
					->setBodyClass("menu-close")
					->setBodyClass("menu-working")
//					->setBodyClass("menu-close-allways")
					->setBodyAttr("data-menu-collapse" , "100000");

				if ($this->vars->data["set_menu_collapse_logo"]) {
					$this->setBodyClass("menu-logo-inside");
				}

			break;

		}
	

		//full page scroller for one pages only
		if (defined("STP_ENABLE_ONEPAGE") && STP_ENABLE_ONEPAGE) {
			if ($this->vars->data["set_fp"]) {
				$this->setBodyAttr("data-scroll-page" , "true");
			}

			if ($this->vars->data["set_fp_menu"]) {
				$this->setBodyAttr("data-scroll-menu" , "true");
			}
		}

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function copyrightBar($layout) {

		if ($layout && !is_array($layout)) {
			$layout = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_id={$layout} ");			
		}
		

		if ($layout["layout_copyright_bar"]) {
			$tmp = new CTemplateDynamic($this->tpl_path . "copyright.htm");
			$bg = array(
				"bg_s_class"	=> "",
				"bg_s_html"		=> "",
				"bg_c_class"	=> "",
				"bg_c_html"		=> "",
			);
			
			if ($layout["layout_copyright_bar_background"]) {
				$_bg = $this->plugins["backgrounds"]->GetBg($layout["layout_copyright_bar_background"]);

				if (is_array($_bg)) {

					if ($_bg["bg:scheme"]) {
						$bg["bg:scheme"] = $_bg["bg:scheme"];
					}

					switch ($layout["layout_copyright_bar_background_style"]) {
						default:
								$bg["bg_s_class"] = $_bg["class"];
								$bg["bg_s_html"] = $_bg["html"];
						break;
						case "1":
								$bg["bg_c_class"] = $_bg["class"];
								$bg["bg_c_html"] = $_bg["html"];
						break;
					}					
				}				
			}

			return $tmp->blockReplace("Footer" , $bg , $_TSM);
		}

	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ChangeSkin() {
		global $_SESS , $_CONF;

		if ($_GET["skin_id"] == "remove") {
			if (isset($_SESS["locale"])) {
				unset($_SESS["locale"]["skin"]);
			}
			
		} elseif ($_GET["skin_id"] && is_array($skin = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:skins']} WHERE skin_id=%d" , array($_GET["skin_id"]))) ) {
			$_SESS["locale"]["skin"] = $skin["skin_id"];
		}
		
		urlredirect($_CONF["url"]);
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Overlay($id) {
		if ($id > 0) {
			return "overlay-class overlay-class-{$id}";
		}		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CookieNotification() {

		if ($_COOKIE["cn"]) {
			return "";
		}
		

		$tpl = new CTemplateDynamic($this->tpl_path . "cookies.htm");


		$more = $this->plugins["modules"]->BuildLink(array(
			"type"	=> $this->vars->data["set_cookies_link_type"],
			"link"	=> $this->vars->data["set_cookies_link_link"],
			"module"=> $this->vars->data["set_cookies_link_module"],
			"global"=> $this->vars->data["set_cookies_link_global"]
		));

	
		$vars = $this->vars->data;

		$vars["set_cookies_style"] = str_replace("," , " " , $vars["set_cookies_style"]);
		$vars["set_cookies_accept_style"] = str_replace("," , " " , $vars["set_cookies_accept_style"]);

		$this->plugins["seo"]->AppendToBody(
			$tpl->blockReplace(
				"Main",
				array(

					"btn_more"	=> $more ? $tpl->blockReplace(
						"Button",
						array(
							"link"	=> $more
						)						
					) : ""
				),
				$vars
			)

		);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CookiesAccept() {
		//expire in 30 days;
		$expire = time() + 3600*24* $this->vars->data["set_cookies_remember"];

		//set the referer	
		setcookie ( 
				"cn" , 
				"1",
				$expire,
				"/", 
				false
		);	

		return "1";
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setBodyAttr($attr , $value, $overwrite = false) {

		if ($this->body[$attr]) {
			if ($overwrite) {
				$this->body[$attr] = $value;
			}			
		} else {
			$this->body[$attr] = $value;
		}

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function bodyAttrs() {
		global $_TSM;

		if (is_array($this->body)) {
			foreach ($this->body as $key => $val) {
				$_TSM["BODY-EXTRA-ATTR"] .= " {$key}='{$val}' ";
			}			
		}		

		$this->body = array();


		if (is_Array($this->bodyClass)) {
			$_TSM["BODY-EXTRA-CLASS"] .= " " . implode(" " , $this->bodyClass);
		}		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setBodyClass($class) {
		$this->bodyClass[$class] = $class;

		return $this;
	}
	
	
}

?>